package gov.va.med.mhv.usermgmt.main.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.data.model.MviAuthComm;
import gov.va.med.mhv.usermgmt.data.repository.MviAuthCommRepository;
import gov.va.med.mhv.usermgmt.service.MviAuthCommService;

@Component
public class MviAuthCommServiceImpl implements MviAuthCommService {

	private static Logger log = LogManager.getLogger(MviAuthCommServiceImpl.class);

	@Autowired
	private MviAuthCommRepository mviAuthCommRepository;

	@Override
	public void saveMviAuthComm(MviAuthComm mviAuthComm, ResponseUtil response) {

		MviAuthComm storedMviAuthComm = null;

		try {
			storedMviAuthComm = mviAuthCommRepository.save(mviAuthComm);
		} catch (Exception e) {
			log.error("Error in storing MviAuthComm details", e);
			response.setFailure(true);
			response.setFailureMessage("Error in storing MviAuthComm details" + e.getMessage());
		}

		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(storedMviAuthComm);
	}
}
